package ru.yandex.iex.proxy.xutils.mailsender.limiters;

import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.CollectionParser;

public class DomainLimiterFactory
    extends AbstractConfigurableLimiterFactory
    implements IexForwardLimiter
{
    public static final String PROPERTY = "domain";

    private static final String FILE = "file";

    protected final Set<String> domains;

    public DomainLimiterFactory(final IniConfig config) throws ConfigException {
        super(config);

        Set<String> domains;
        if (config.keys().contains(FILE)) {
            try {
                domains = Files.lines(config.getInputFile(FILE).toPath())
                    .collect(Collectors.toSet());
            } catch (IOException ioe) {
                throw new ConfigException("Failed to load file", ioe);
            }
        } else {
            domains =
                config.get(
                    "list",
                    new CollectionParser<>(String::trim, LinkedHashSet::new));
        }
        if (domains == null || domains.size() == 0) {
            throw new ConfigException("Domains limiter is empty");
        }

        this.domains = Collections.unmodifiableSet(domains);
    }

    @Override
    public IexForwardLimiter create() {
        return this;
    }

    @Override
    public boolean acquire(
        final AbstractEntityContext context,
        final long millsFromDayStart)
    {
        return domains.contains(context.getDomain());
    }

    @Override
    public String toString() {
        return "DomainLimiterFactory{" + "domains=" + domains + '}';
    }
}
