package ru.yandex.iex.proxy.xutils.mailsender.limiters;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.CollectionParser;

public class FromEmailLimiterFactory
    extends AbstractConfigurableLimiterFactory
    implements IexForwardLimiter
{
    public static final String PROPERTY = "froms";

    private final Set<String> froms;

    public FromEmailLimiterFactory(
        final IniConfig config)
        throws ConfigException
    {
        super(config);

        Set<String> froms =
            config.get(
                "list",
                new CollectionParser<>(x -> x, LinkedHashSet::new));
        if (froms == null || froms.size() == 0) {
            throw new ConfigException("Froms email limiter is empty");
        }

        this.froms = Collections.unmodifiableSet(froms);
    }

    @Override
    public IexForwardLimiter create() {
        return this;
    }

    @Override
    public boolean acquire(
        final AbstractEntityContext context,
        final long millsFromDayStart)
    {
        return froms.contains(context.getFrom());
    }

    @Override
    public String toString() {
        return "FromEmailLimiterFactory{froms=" + froms + '}';
    }
}
