package ru.yandex.iex.proxy.xutils.mailsender.limiters;

import java.util.List;

import ru.yandex.iex.proxy.AbstractEntityContext;

public class IexProxyMultiLimiter implements IexForwardLimiter {
    private final List<IexForwardLimiter> limiters;

    public IexProxyMultiLimiter(final List<IexForwardLimiter> limiters) {
        this.limiters = limiters;
    }

    @Override
    public boolean acquire(
        final AbstractEntityContext context,
        final long millsFromDayStart)
    {
        for (IexForwardLimiter limiter: limiters) {
            if (!limiter.acquire(context, millsFromDayStart)) {
                return false;
            }
        }

        return true;
    }
}
