package ru.yandex.iex.proxy.xutils.mailsender.limiters;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class PerdomainLimiterFactory
    extends AbstractConfigurableLimiterFactory
{
    public static final String PROPERTY = "perdomain";

    private final Map<String, Boolean> domainsMap;

    public PerdomainLimiterFactory(
        final IniConfig config)
        throws ConfigException
    {
        super(config);

        DomainLimiterFactory domainLimiter = new DomainLimiterFactory(config);
        this.domainsMap = domainLimiter.domains.stream().collect(
            Collectors.toMap(
                Function.identity(),
                (k) -> Boolean.TRUE));
    }

    @Override
    public IexForwardLimiter create() {
        return new PerDomainLimiter(domainsMap);
    }

    private static final class PerDomainLimiter implements IexForwardLimiter {
        private final ConcurrentHashMap.KeySetView<String, Boolean> domains;

        private PerDomainLimiter(
            final Map<String, Boolean> domains)
        {
            this.domains = new ConcurrentHashMap<>(domains).keySet();
        }

        @Override
        public boolean acquire(
            final AbstractEntityContext context,
            final long millsFromDayStart)
        {
            return domains.remove(context.getDomain());
        }

        @Override
        public String toString() {
            return "PerDomainLimiter{ domains left =" + domains + '}';
        }
    }
}
