package ru.yandex.iex.proxy.xutils.mailsender.limiters;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class PeremailLimiterFactory
    extends AbstractConfigurableLimiterFactory
{
    public static final String PROPERTY = "peremail";

    private final Map<String, Integer> limits;

    public PeremailLimiterFactory(
        final IniConfig config)
        throws ConfigException
    {
        super(config);

        Map<String, Integer> limits = new LinkedHashMap<>();
        for (String key: config.keys()) {
            limits.put(key, config.getInt(key));
        }

        if (limits.size() == 0) {
            throw new ConfigException("PerEmail limiter is empty");
        }

        this.limits = Collections.unmodifiableMap(limits);
    }

    @Override
    public IexForwardLimiter create() {
        Map<String, AtomicInteger> limits =
            new LinkedHashMap<>(this.limits.size());
        for (Map.Entry<String, Integer> entry: this.limits.entrySet()) {
            limits.put(entry.getKey(), new AtomicInteger(entry.getValue()));
        }

        return new PerEmailLimiter(limits);
    }

    private static final class PerEmailLimiter implements IexForwardLimiter {
        private final Map<String, AtomicInteger> limits;

        private PerEmailLimiter(final Map<String, AtomicInteger> limits) {
            this.limits = limits;
        }

        @Override
        public boolean acquire(
            final AbstractEntityContext context,
            final long millsFromDayStart)
        {
            AtomicInteger counter = this.limits.get(context.getFrom());

            return counter != null
                && counter.get() > 0
                && counter.getAndDecrement() > 0;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("PerEmailLimiter{limits=");
            for (Map.Entry<String, AtomicInteger> entry: limits.entrySet()) {
                sb.append(entry.getKey());
                sb.append(':');
                sb.append(entry.getValue().get());
                sb.append(' ');
            }

            sb.append('}');
            return sb.toString();
        }
    }
}
