package ru.yandex.iex.proxy.xutils.mailsender.limiters;

import java.util.concurrent.TimeUnit;

import ru.yandex.function.GenericFunction;
import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class TimerangeLimiterFactory
    extends AbstractConfigurableLimiterFactory
    implements IexForwardLimiter
{
    public static final String PROPERTY = "timerange";

    public static final String DEFAULT_START = "13:30.00";
    public static final String DEFAULT_END = "13:35.00";

    private static final int MIN_TIME_VALUE = 0;
    private static final int MAX_TIME_VALUE = 2359;

    private static final TimeStringParser PARSER = new TimeStringParser();

    private final long start;
    private final long end;

    public TimerangeLimiterFactory(
        final IniConfig config)
        throws ConfigException
    {
        super(config);

        this.start =
            config.get("start-time", PARSER.apply(DEFAULT_START), PARSER);
        this.end =
            config.get("end-time", PARSER.apply(DEFAULT_END), PARSER);
    }

    @Override
    public IexForwardLimiter create() {
        return this;
    }

    @Override
    public boolean acquire(
        final AbstractEntityContext context,
        final long millsFromDayStart)
    {
        return millsFromDayStart >= start && millsFromDayStart <= end;
    }

    @Override
    public String toString() {
        return "TimerangeLimiter {start=" + start + ", end=" + end + '}';
    }

    private static final class TimeStringParser
        implements GenericFunction<String, Long, ConfigException>
    {
        @Override
        public Long apply(final String s) throws ConfigException {
            String[] hourMinSplit = s.split(":");
            if (hourMinSplit.length == 2) {
                String[] secsSplit = hourMinSplit[1].split("\\.");
                if (secsSplit.length == 2) {
                    long result;
                    try {
                        result =
                            TimeUnit.HOURS.toMillis(
                                Integer.parseInt(hourMinSplit[0]));
                        result += TimeUnit.MINUTES.toMillis(
                            Integer.parseInt(secsSplit[0]));
                        result += TimeUnit.SECONDS.toMillis(
                            Integer.parseInt(secsSplit[1]));
                    } catch (NumberFormatException nfe) {
                        throw new ConfigException("Bad time value " + s, nfe);
                    }

                    if (result <= MIN_TIME_VALUE || result >= MAX_TIME_VALUE) {
                        return result;
                    } else {
                        throw new ConfigException(
                            "Value ot of range " + result);
                    }
                }
            }

            throw new ConfigException("Bad string format " + s);
        }
    }
}
