package ru.yandex.iex.proxy.xutils.mailsender.limiters;

import java.util.concurrent.atomic.AtomicInteger;

import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class TotalLimiterFactory
    extends AbstractConfigurableLimiterFactory
{
    public static final String PROPERTY = "total";

    public static final int DEFAULT_LIMIT = 1;

    public static final TotalLimiterFactory DEFAULT =
        new TotalLimiterFactory(DEFAULT_LIMIT);

    private final int limit;

    public TotalLimiterFactory(final int limit) {
        this.limit = limit;
    }

    public TotalLimiterFactory(
        final IniConfig config)
        throws ConfigException
    {
        super(config);

        this.limit = config.getInt("limit", DEFAULT_LIMIT);
    }

    @Override
    public IexForwardLimiter create() {
        return new TotalLimiter(limit);
    }

    private static final class TotalLimiter implements IexForwardLimiter {
        private final AtomicInteger left;

        private TotalLimiter(final int limit) {
            this.left = new AtomicInteger(limit);
        }

        @Override
        public boolean acquire(
            final AbstractEntityContext context,
            final long millsFromDayStart)
        {
            return left.get() > 0 && left.getAndDecrement() > 0;
        }

        @Override
        public String toString() {
            return "TotalLimiter{ left=" + left.get() + '}';
        }
    }
}
