package ru.yandex.iex.proxy.xutils.mailsender.limiters;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.iex.proxy.MessageTypesCodeOrEnumParser;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.email.types.MessageType;
import ru.yandex.parser.string.CollectionParser;

public class TypesLimiterFactory
    extends AbstractConfigurableLimiterFactory
    implements IexForwardLimiter
{
    public static final String PROPERTY = "types";

    protected final Set<MessageType> types;
    protected final boolean any;
    protected final boolean not;

    public TypesLimiterFactory(final IniConfig config) throws ConfigException {
        super(config);

        types =
            config.get(
                "list",
                Collections.emptySet(),
                new CollectionParser<>(
                    new MessageTypesCodeOrEnumParser(null),
                    LinkedHashSet::new));

        any = config.getBoolean("any", true);
        not = config.getBoolean("not", false);

        if (types.isEmpty()) {
            throw new ConfigException(
                "Message types in limiter config are empty");
        }
    }

    @Override
    public IexForwardLimiter create() {
        return this;
    }

    @Override
    public boolean acquire(
        final AbstractEntityContext context,
        final long millsFromDayStart)
    {
        if (any) {
            boolean matched = false;
            for (MessageType type: types) {
                if (context.getTypes().contains(type)) {
                    matched = true;
                    break;
                }
            }
            return matched ^ not;
        } else {
            return context.getTypes().containsAll(types) ^ not;
        }
    }

    @Override
    public String toString() {
        return "TypesLimiterFactory{ types=" + types
            + ", any=" + any + ", not=" + not + '}';
    }
}
