package ru.yandex.iex.proxy.xutils.replace;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;

public final class HrefReplacer {
    private static HrefReplacer instance;

    private static final String HREF_REGEX =
        "href=[\'\"]?http[^\'\"\\s]*['\"\\s]";
    private static final String HREF_MOCK = "href=\"http://ya.ru";
    private static final int BOUND = 10000;

    private Set<String> actionKeywords = new HashSet<>();

    private final Random random = new Random();

    static {
        try {
            instance = new HrefReplacer();
        } catch (IOException e) {
            throw new RuntimeException("HrefReplacer creation failed", e);
        }
    }

    private HrefReplacer() throws IOException {
        try (BufferedReader br = new BufferedReader(
            new InputStreamReader(
                NameChecker.class.getResourceAsStream("action_keywords.txt"),
                StandardCharsets.UTF_8)))
        {
            String line;
            while ((line = br.readLine()) != null) {
                String word = line.toLowerCase(Locale.getDefault());
                actionKeywords.add(word);
            }
        }
    }

    public static HrefReplacer getInstance() {
        return instance;
    }

    public String replace(final String in) {
        Matcher matcher = Pattern.compile(HREF_REGEX).matcher(in);
        List<String> searchList = new ArrayList<>();
        List<String> replaceList = new ArrayList<>();
        while (matcher.find()) {
            String href = matcher.group();
            searchList.add(href);
            replaceList.add(mockHref(href.toLowerCase(Locale.ROOT)));
        }
        return StringUtils.replaceEach(
            in,
            searchList.toArray(new String[0]),
            replaceList.toArray(new String[0]));
    }

    private String mockHref(final String href) {
        StringBuilder mock = new StringBuilder(HREF_MOCK);
        for (String keyword : actionKeywords) {
            if (href.contains(keyword)) {
                mock.append('/').append(keyword);
            }
        }
        mock.append("/random?id=").append(random.nextInt(BOUND)).append('\"');
        return mock.toString();
    }
}
