package ru.yandex.iex.proxy.xutils.replace;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class NameReplacer {
    private static NameReplacer instance;

    private static final String[] SKIP_SURNAME_LIST = {
        "Number"
    };
    private static final Set<String> SKIP_SURNAME_SET =
        new HashSet<>(Arrays.asList(SKIP_SURNAME_LIST));

    private Set<String> months = new HashSet<>();

    static {
        try {
            instance = new NameReplacer();
        } catch (IOException e) {
            throw new RuntimeException("NameReplacer creation failed", e);
        }
    }

    private NameReplacer() throws IOException {
        try (BufferedReader br = new BufferedReader(
            new InputStreamReader(
                NameReplacer.class.getResourceAsStream("months.txt"),
                StandardCharsets.UTF_8)))
        {
            String line;
            while ((line = br.readLine()) != null) {
                String month = line.toLowerCase(Locale.getDefault());
                months.add(month);
            }
        }
    }

    public static NameReplacer getInstance() {
        return instance;
    }

    public String replace(final String in) {
        NameChecker nameChecker = NameChecker.getInstance();
        List<String> words = makeListOfWords(in);
        String res = in;
        for (String word : words) {
            if (isMonth(word)) {
                continue;
            }
            if (word.length() > 1 && isAlpha(word)) {
                if (nameChecker.probablePatronymic(word)) {
                    res = res.replace(word, "Аркадьевич");
                } else if (nameChecker.probableSurname(word)) {
                    if (SKIP_SURNAME_SET.contains(word)) {
                        continue;
                    }
                    res = res.replace(word, "Аркадьев");
                } else if (nameChecker.probableName(word)) {
                    res = res.replace(word, "Аркадий");
                }
            }
        }
        return res;
    }

    private boolean isMonth(final String word) {
        String lowerCaseWord = word.toLowerCase(Locale.getDefault());
        for (String month : months) {
            if (lowerCaseWord.startsWith(month)) {
                return true;
            }
        }
        return false;
    }

    private boolean isAlpha(final String s) {
        for (Character x : s.toCharArray()) {
            if (!Character.isAlphabetic(x)) {
                return false;
            }
        }
        return true;
    }

    private List<String> makeListOfWords(final String text) {
        return Arrays.asList(text.split("[^a-zA-Zа-яА-ЯёЁйЙ]+"));
    }
}
