package ru.yandex.iex.proxy.xutils.replace;

public final class PhoneReplacer {
    private static PhoneReplacer instance = new PhoneReplacer();

    private static final String PHONE_REGEXP =
        "(\\+7|8)\\s?\\(?[0-9]{3}\\)?\\s?[0-9]{3}-?[0-9]{2}-?[0-9]{2}";

    private PhoneReplacer() {
    }

    public static PhoneReplacer getInstance() {
        return instance;
    }

    public String replace(final String in) {
        return in.replaceAll(PHONE_REGEXP, "+7 (666) 666 66-66");
    }
}
