package ru.yandex.iex.proxy.xutils.tjson;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TJson {
    public static final char S = '.';
    public static final String PREFIX = "#";

    private Map<String, Object> root = new HashMap<>();
    private Object curLocation;

    public TJson(final Object json) {
        if (json != null) {
            root.put("root", json);
        }
        curLocation = root;
    }

    public TJson() {
        curLocation = root;
    }

    public Map<String, Object> getRoot() {
        return root;
    }

    public Object get(final String path) {
        Object node = findNode(path, false, false);
        return node;
    }

    public void put(
        final String patha,
        final Object value)
    {
        String path = patha;
        if (!path.contains(String.valueOf(S))) {
            path = S + patha;
        }
        int lastDotIndex = path.lastIndexOf(S);
        String lastKey = path.substring(lastDotIndex + 1);
        if (!lastKey.startsWith(PREFIX)) {
            Object node =
                findNode(path.substring(0, lastDotIndex), true, true);
            pushToMap(node, lastKey, value);
        }
    }

    private Object findNode(
        final String patha,
        final Boolean buildNode,
        final Boolean isValueMap)
    {
        String path = "root." + patha;
        Object result = null;
        String[] paths = path.split("\\.");
        Object cur = curLocation;
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i].startsWith(PREFIX)) {
                // list case
                Integer id = Integer.valueOf(paths[i].substring(1));
                if (cur instanceof List) {
                    Object node = null;
                    @SuppressWarnings("unchecked")
                    List<Object> curlist = (List) cur;
                    if (id < ((List) cur).size()) {
                        if (buildNode) {
                            if (isValueMap) {
                                curlist.set(id, new HashMap<>());
                            } else {
                                curlist.set(id, new ArrayList<>());
                            }
                        }
                        node = ((List) cur).get(id);
                    }
                    if (i == paths.length - 1) {
                        result = node;
                        break;
                    } else {
                        cur = node;
                    }
                } else {
                    if (buildNode) {
                        cur = new ArrayList<>(id + 1);
                        --i;
                    } else {
                        break;
                    }
                }
            } else {
                // map case
                if (cur instanceof Map) {
                    Map<?, ?> m = (Map<?, ?>) cur;
                    if (i == paths.length - 1) {
                        if (!m.containsKey(paths[i])) {
                            if (buildNode) {
                                if (isValueMap) {
                                    pushToMap(
                                        m,
                                        paths[i],
                                        new HashMap<String, Object>());
                                } else {
                                    pushToMap(
                                        m,
                                        paths[i],
                                        new ArrayList<>());
                                }
                            }
                        }
                        result = m.get(paths[i]);
                        break;
                    } else {
                        if (m.containsKey(paths[i])
                            && (m.get(paths[i])) instanceof Map)
                        {
                            cur = m.get(paths[i]);
                        } else {
                            if (buildNode) {
                                cur = new HashMap<String, Object>();
                                pushToMap(m, paths[i], cur);
                            } else {
                                break;
                            }
                        }
                    }
                } else {
                    if (buildNode) {
                        cur = new HashMap<String, Object>();
                        --i;
                    } else {
                        break;
                    }
                }
            }
        }
        return result;
    }

    private void pushToMap(
        final Object map,
        final String key,
        final Object value)
    {
        if (map instanceof Map) {
            Map<?, ?> pmap = (Map<?, ?>) map;
            @SuppressWarnings("unchecked")
            Map<String, Object> rmap = (Map<String, Object>) pmap;
            rmap.put(key, value);
        }
    }
}
