package ru.yandex.iex.proxy.xutils.transliter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

//CSOFF: MultipleStringLiterals
public class SimpleTranslit {
    private static ArrayList<Map<Character, String>> schemes =
        new ArrayList<>();

    static {
        String[][][] rawSchemes = {
            {
                {"а", "a"},
                {"б", "b"},
                {"в", "v"},
                {"г", "g"},
                {"д", "d"},
                {"е", "e"},
                {"ё", "jo"},
                {"ж", "zh"},
                {"з", "z"},
                {"и", "i"},
                {"й", "jj"},
                {"к", "k"},
                {"л", "l"},
                {"м", "m"},
                {"н", "n"},
                {"о", "o"},
                {"п", "p"},
                {"р", "r"},
                {"с", "s"},
                {"т", "t"},
                {"у", "u"},
                {"ф", "f"},
                {"х", "kh"},
                {"ц", "c"},
                {"ч", "ch"},
                {"ш", "sh"},
                {"щ", "shh"},
                {"ъ", "''"},
                {"ы", "y"},
                {"ь", "'"},
                {"э", "eh"},
                {"ю", "ju"},
                {"я", "ja"}
            },
            {
                {"а", "a"},
                {"б", "b"},
                {"в", "v"},
                {"г", "g"},
                {"д", "d"},
                {"е", "e"},
                {"ё", "e"},
                {"ж", "zh"},
                {"з", "z"},
                {"и", "i"},
                {"й", "i"},
                {"к", "k"},
                {"л", "l"},
                {"м", "m"},
                {"н", "n"},
                {"о", "o"},
                {"п", "p"},
                {"р", "r"},
                {"с", "s"},
                {"т", "t"},
                {"у", "u"},
                {"ф", "f"},
                {"х", "kh"},
                {"ц", "tc"},
                {"ч", "ch"},
                {"ш", "sh"},
                {"щ", "shch"},
                {"ъ", ""},
                {"ы", "y"},
                {"ь", ""},
                {"э", "e"},
                {"ю", "iu"},
                {"я", "ia"}
            },
            {
                {"а", "a"},
                {"б", "b"},
                {"в", "v"},
                {"г", "g"},
                {"д", "d"},
                {"е", "e"},
                {"ё", "e"},
                {"ж", "zh"},
                {"з", "z"},
                {"и", "i"},
                {"й", "i"},
                {"к", "k"},
                {"л", "l"},
                {"м", "m"},
                {"н", "n"},
                {"о", "o"},
                {"п", "p"},
                {"р", "r"},
                {"с", "s"},
                {"т", "t"},
                {"у", "u"},
                {"ф", "f"},
                {"х", "kh"},
                {"ц", "ts"},
                {"ч", "ch"},
                {"ш", "sh"},
                {"щ", "shch"},
                {"ъ", "ie"},
                {"ы", "y"},
                {"ь", ""},
                {"э", "e"},
                {"ю", "iu"},
                {"я", "ia"}
            },
            {
                {"а", "a"},
                {"б", "b"},
                {"в", "v"},
                {"г", "g"},
                {"д", "d"},
                {"е", "e"},
                {"ё", "e"},
                {"ж", "j"},
                {"з", "z"},
                {"и", "i"},
                {"й", "i"},
                {"к", "k"},
                {"л", "l"},
                {"м", "m"},
                {"н", "n"},
                {"о", "o"},
                {"п", "p"},
                {"р", "r"},
                {"с", "s"},
                {"т", "t"},
                {"у", "u"},
                {"ф", "f"},
                {"х", "h"},
                {"ц", "c"},
                {"ч", "ch"},
                {"ш", "sh"},
                {"щ", "sc"},
                {"ъ", ""},
                {"ы", "y"},
                {"ь", ""},
                {"э", "e"},
                {"ю", "iu"},
                {"я", "ia"}
            }
        };

        for (int i = 0; i < rawSchemes.length; ++i) {
            Map<Character, String> ruToEnTable = new HashMap<>();
            for (int j = 0; j < rawSchemes[i].length; ++j) {
                ruToEnTable.put(
                    rawSchemes[i][j][0].charAt(0),
                    rawSchemes[i][j][1]);
            }
            schemes.add(ruToEnTable);
        }
    }

    public String ruToEn(final String w) {
        return ruToEnForScheme(w, schemes.get(0));
    }

    public ArrayList<String> ruToEnAllOption(final String w) {
        ArrayList<String> res = new ArrayList<>();
        for (Map<Character, String> sch : schemes) {
            res.add(ruToEnForScheme(w, sch));
        }
        return res;
    }

    private String ruToEnForScheme(
        final String w,
        final Map<Character, String> ruToEnTable)
    {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < w.length(); i++) {
            String res = ruToEnTable.get(Character.toLowerCase(w.charAt(i)));
            if (res != null) {
                if (Character.isUpperCase(w.charAt(i))) {
                    sb.append(Character.toUpperCase(res.charAt(0)));
                    for (int j = 1; j < res.length(); ++j) {
                        sb.append(res.charAt(j));
                    }
                } else {
                    sb.append(res);
                }
            }
        }
        return new String(sb);
    }
}
// CSON: MultipleStringLiterals
