#!/bin/sh

CONFIG=iex-proxy.conf

jars="../../build/dist/iex-proxy/iex-proxy.jar"

CLASSNAME="ru.yandex.iex.proxy.IexProxy"

RETVAL=0
DAEMON_COREFILE_LIMIT=unlimited
PATH=/sbin:/bin:/usr/bin:/usr/sbin
PORT=1341

progmaxmem=3000000
#if [ -x /bin/grep -a -x /bin/awk ] ; then
#	progmaxmem=`/bin/grep MemTotal /proc/meminfo |/bin/awk '{printf( "%d", ($2*35/100));}'`
#else
#	progmaxmem="15000000"

SEARCHMAP=searchmap_mail.txt

CPUCORES=`cat /proc/cpuinfo | grep processor | wc -l`

XMN=$((progmaxmem*30/100))
if [ $XMN -gt $((2 * 1024 * 1024)) ]; then
    XMN=$((2*1024*1024))
fi

if [ "$CPUCORES" -gt 2 ]; then
    CONCURRENT_BACKGROUND="-Xconcurrentbackground$((CPUCORES-2))"
fi

prog="/usr/lib/jvm/java-1.7.0-ibm-wrt-3.64/jre/bin/java"
prog="/opt/ibm/java-x86_64-80/bin/java"

progarg="-Dcom.sun.management.jmxremote
-Dcom.sun.management.jmxremote.ssl=false
-Dcom.sun.management.jmxremote.authenticate=false
-Dcom.sun.management.jmxremote.port=$PORT
-Djava.library.path=/opt/lucene
-Xdump:system+heap+java:events=systhrow+user,filter=java/lang/OutOfMemoryError,request=exclusive+prepwalk+compact
-Xgcpolicy:gencon
$CONCURRENT_BACKGROUND
-Xconcurrentlevel8
-Xgcthreads$((CPUCORES))
-Xnoclassgc
-Xmn${XMN}K
-Xmx${progmaxmem}K
-Xloa
-Xmr10M
-Xpartialcompactgc
-Djava.net.preferIPv4Stack=false
-Djava.net.preferIPv6Addresses=true
-DLOGDIR=$HOME/log
-DSEARCHMAP=$SEARCHMAP
-cp $jars
$CLASSNAME $CONFIG"

ulimit -s 1024
ulimit -n 1000000

$prog $progarg
