JAVA_PROGRAM(iex_proxy)

JDK_VERSION(11)

OWNER(g:personal-search)

INCLUDE(${ARCADIA_ROOT}/mail/persdata/build/strict_java_check.inc)

JAVA_SRCS(SRCDIR main/java **/*.java)
JAVA_SRCS(SRCDIR main/resources **/*)

PEERDIR(
    contrib/java/com/google/guava/guava
    contrib/java/io/netty/netty-common
    contrib/java/org/apache/commons/commons-lang3
    mail/contrib/httpcomponents/httpclient/httpmime
    mail/library/geocoder
    mail/library/html/html_parser
    mail/library/jniwrapper
    mail/library/logbroker/lb_logger
    mail/library/multistarter
    mail/search/peach
    mail/search/search_backend
    mail/search/mail/mail_search_strings
    mail/search/mail/wmi_client
    mail/search/universal_search_proxy
    mail/so/libs/java/received_parser
    mail/so/libs/java/senders_addrs
    mail/so/libs/java/shingler_client
    mail/so/libs/java/so_factors
    mail/util/fast_md5
)

EXCLUDE(contrib/java/org/anarres/lzo/lzo-core/1.0.5)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/mail/tools/templates/classpath.template.sh
    OUT ${BINDIR}/classpath.sh
    CUSTOM_PROPERTY packageName iex_proxy
)

END()

IF (SANITIZER_TYPE != "memory" AND SANITIZER_TYPE != "undefined")
    RECURSE_FOR_TESTS(
        test
    )
ENDIF()

