#!/bin/bash
set -exo pipefail

source recommended_java_args.sh
source classpath.sh

if [ -z "$CPU_CORES" ]; then
    if [ "$CPU_LIMIT" != "" ]; then
        export CPU_CORES=$(echo $CPU_LIMIT | awk '{print int($1)}')
    else
        export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk '{print int($1)}')
    fi
fi

source gc_args.sh

export CLASS="ru.yandex.iex.proxy.IexProxy"

case "$NANNY_SERVICE_ID" in
    iex-proxy-prod*)
        export CMDLINE=$BSCONFIG_IDIR/iex-proxy-iss-prod.conf
        if [ "$NANNY_SERVICE_ID" == "iex-proxy-prod4" -o "$NANNY_SERVICE_ID" == "iex-proxy-prod-so" ]; then
            export ATTACHSHIELD_KEY=qwe
            export ATTACHSHIELD_IV=asd
            export DATA_SYNC_SECRET=zxc
            export ATTACHSID_AES_KEY=123
            export ATTACHSID_HMAC_KEY=321
            export CLASS="ru.yandex.multistarter.MultiStarter"
            export CMDLINE="ru.yandex.msearch.Daemon -config $BSCONFIG_IDIR/lucene.conf ; ru.yandex.peach.Peach $BSCONFIG_IDIR/peach.conf ; ru.yandex.iex.proxy.IexProxy $BSCONFIG_IDIR/iex-proxy-iss-prod.conf"
        fi
        if [ "$NANNY_SERVICE_ID" == "iex-proxy-prod" ]; then
            export BSCONFIG_IPORT=21953
        fi
        ;;
    iex-proxy-testing*)
        export CMDLINE=$BSCONFIG_IDIR/iex-proxy-iss-testing.conf
        export ADDITIONAL_ARGS="-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=5005"
        ;;
esac



LD_LIBRARY_PATH=$JAVA_LD_LIBRARY_PATH LD_PRELOAD=$JAVA_LD_PRELOAD exec \
    $BSCONFIG_IDIR/jdk/bin/java \
    -Dcom.sun.management.jmxremote \
    -Dcom.sun.management.jmxremote.ssl=false \
    -Dcom.sun.management.jmxremote.authenticate=false \
    -Dcom.sun.management.jmxremote.port=$((BSCONFIG_IPORT+8)) \
    -Djava.rmi.server.hostname=$BSCONFIG_IHOST \
    -Djava.library.path=$BSCONFIG_IDIR/iex_proxy \
    -XX:+DisableExplicitGC \
    -verbose:gc \
    $GC_ARGS \
    $ADDITIONAL_ARGS \
    -Djava.net.preferIPv4Stack=false \
    -Djava.net.preferIPv6Addresses=true \
    -DBSCONFIG_IPORT=$BSCONFIG_IPORT \
    -DBSCONFIG_IHOST=$BSCONFIG_IHOST \
    -DBSCONFIG_INAME=$BSCONFIG_INAME \
    -DBSCONFIG_IDIR=$BSCONFIG_IDIR \
    -DSEARCHMAP=searchmap.txt \
    -DIEX_PROXY_TYPE=$NANNY_SERVICE_ID \
    -DPORTO=1 \
    -cp $CLASSPATH \
    $CLASS $CMDLINE

