#pragma once

#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/json_writer.h>

#include <util/generic/map.h>
#include <util/generic/strbuf.h>

class TParser {
private:
public:
    bool inString(TString substr, TString s) {
        if (s.find(substr) != TString::npos)
            return 1;
        return 0;
    }

    TString toJson(TString name, TString type) {
        TString json1 = "{\"name\" : \"\"";
        TString json2 = ",\"type\" : \"\"}";
        json1.insert(11, name);
        json2.insert(11, type);
        return json1 + json2;
    }

    TString addressIdentity(TString address) {
        if (addressOwner.find(address) != addressOwner.end())
            return addressOwner[address];
        return "NaN";
    }

    TString combo(TString title, TString text) {
        if (inString("добро пожаловать", title) && text != "") {
            return toJson("combo.mail.ru", "new_sub");
        } else if (inString("благодарим за продление подписки!", title) ) {
            return toJson("combo.mail.ru", "resub");
        } else if (inString("Нам не удалось продлить вашу подписку", title)) {
            return toJson("combo.mail.ru", "failure");
        }else if (inString("Ваша карта удалена из личного кабинета", title)) {
            return toJson("combo.mail.ru", "unsub");
        } else if (inString("ЧЕК/ПРИХОД", title) ) {
            return toJson("combo.mail.ru", "check");
        } else if (inString("ЧЕК/ВОЗВРАТ", title) ) {
            return toJson("combo.mail.ru", "return");
        }
        return toJson("combo.mail.ru", "identity fail");
    }

    TString megogo(TString title, TString text) {
        if (inString("Покупка подписки «Максимальная»", title) && inString("1 руб.", text)) {
            return toJson("megogo", "trial, 1 month");
        } else if (inString("Покупка подписки «Премиальная»", title) && inString("1 руб.", text)) {
            return toJson("megogo", "trial, 7 days");
        } else if (inString("Покупка подписки", title)) {
            return toJson("megogo", "resub");
        } else if (inString("Чек", title)) {
            return toJson("megogo", "check");
        }
        return toJson("megogo", "identity fail");
    }

    TString spotify(TString title, TString text) {
        if (inString("Квитанция Spotify", title) && inString("до окончания срока действия пробного периода, мы начнем автоматически", text)) {
            if (inString("списывать ежемесячную плату в размере 169", text)) {
                return toJson("spotify", "trial, 169 rub");
            } else if (inString("списывать ежемесячную плату в размере 219", text)) {
                return toJson("spotify", "trial, 219 rub");
            } else if (inString("списывать ежемесячную плату в размере 269", text)) {
                return toJson("spotify", "trial, 269 rub");
            } else if (inString("списывать ежемесячную плату в размере 85", text)){
                return toJson("spotify", "trial, 85 rub");
            }
        }

        return toJson("spotify", "identity fail");
    }

    TString apply(TStringBuf requestText) {
        NJson::TJsonValue json = NJson::ReadJsonFastTree(requestText);
        auto& jsonMap = json.GetMapSafe();
        auto name = addressIdentity(jsonMap.at("address").GetStringSafe());
        if (name == "NaN")
            return toJson("pass", "address not found");
        if (jsonMap.at("title") == "")
            return toJson("pass", "empty title");
        if (jsonMap.at("text") == "")
            return toJson("pass", "empty mail");
        return mailType(name, jsonMap.at("title").GetStringSafe(), jsonMap.at("text").GetStringSafe());
    }
    //json format = {{\"address\":\"\"}, {\"title\":\"\"},{\"text":\"\"}}
    TVector<TString> convertFromJson(TString json) {
        TVector<TString> ans;
        size_t tmp = 0;
        for (int i = 0; i < 3; ++i) {
            size_t start = json.find(":", tmp) + 3;
            size_t end = json.find("\\", start);
            ans.push_back(json.substr(start, end - start));
            tmp = start;
        }
        return ans;
    }

    TString okko(TString title, TString text) {
        if (title == "Добро пожаловать в Okko!" && text != "") {
            return toJson("okko", "register");
        } else if (title == "Okko.tv: Вы купили подписку") {
            return toJson("okko", "resub");
        }
        return toJson("okko", "identity fail");
    }

    TString wink(TString title, TString text) {
        if (title == "Регистрация в Wink" && text != "") {
            return toJson("wink", "register");
        }
        return toJson("wink", "identity fail");
    }

    TString premier(TString title, TString text) {
        if (title == "Подтверждение email" && text != "") {
            return toJson("premier", "register");
        }
        return toJson("premier", "identity fail");
    }
    TString more_tv(TString title, TString text) {
        if (title == "Подтверждение регистрации на more.tv" && text != "") {
            return toJson("more_tv", "register");
        }
        else if (title == "Всё, поехали на more" && text != "") {
            return toJson("more_tv", "confirm");
        }
        return toJson("more_tv", "identity fail");
    }

    TString ivi(TString title, TString text) {
        if (inString("пробный период подписки", title) && text != "") {
            return toJson("ivi", "trial, 14 days");
        } else if (inString("Вы подключили подписку", title) && text != "" ) {
            return toJson("ivi", "new_sub");
        } else if (inString("Добро пожаловать", title) && text != "" ) {
            return toJson("ivi", "new_sub");   
        } else if (inString("Автопродление подписки", title) && inString("было отключено", title)) {
            return toJson("ivi", "unsub");
        } else if (inString("подписка успешно продлена", title)) {
            return toJson("ivi", "resub");
        }
        return toJson("ivi", "identity fail");
    }

    TString netflix(TString title, TString text) {
        if (inString("Welcome to Netflix", title) && text != "") {
            return toJson("netflix", "trial, 30 days");
        }
        return toJson("netflix", "identity fail");
    }

    TString mailType(TString name, TString title, TString text) {
        if (name == "combo.mail.ru") {
            return combo(title, text);
        } else if (name == "megogo") {
            return megogo(title, text);
        } else if (name == "okko") {
            return okko(title, text);
        } else if (name == "wink") {
            return wink(title, text);
        } else if (name == "ivi") {
            return ivi(title, text);
        } else if (name == "netflix") {
            return netflix(title, text);
        } else if (name == "spotify") {
            return spotify(title, text);
       } else if (name == "premier") {
            return premier(title, text);
        } else if (name == "more_tv") {
            return more_tv(title, text);
        }
        return toJson(name, "error: wrong name in class_parser -> mailType");
    }

protected:
    //MAP длительности триалов
    TMap<TString, TString> trialPeriod{
        {"combo.mail.ru", "30 days"}, {"okko", "7 days"}, {"megogo_bitva_prestolov", "3 days"} //Битва престолов
        ,
        {"megogo_max", "1 month"} //Максимальная
        ,
        {"megogo_premium", "7 days"} //Премиальная
        ,
        {"ivi", "14 days"},
        {"tvzavr+", "14 days"} //tvzavr+
        ,
        {"wink_for_her", "14 days"} //Для нее
        ,
        {"wink_for_kinomanoff", "7 days"} // Для киноманов
        ,
        {"wink_kids", "7 days"} //Детский клуб
        ,
        {"wink_vip", "7 days"} //КиноViP
        ,
        {"wink_more.tv", "7 days"} //more.tv
        ,
        {"wink_for_1337", "7 days"} //Для ценителей
        ,
        {"wink_lyceum", "7 days"} //Лицей
        ,
        {"wink_english", "7 days"} //English Club
    };

    //MAP с адресами
    TMap<TString, TString> addressOwner{
        {"orders@combo.mail.ru", "combo.mail.ru"},
        {"info@combo.mail.ru", "combo.mail.ru"},
        {"fiscal@corp.mail.ru", "combo.mail.ru"},
        {"hi@okko.tv", "okko"},
        {"digest@okko.tv", "okko"},
        {"Info@okko.tv", "okko"},
        {"team@email.megogo.ru", "megogo"},
        {"noreply@1-ofd.ru", "megogo"},
        {"info@notify.ivi.ru", "ivi"},
        {"noreply@itv.rt.ru", "wink"},
        {"info@mailer.netflix.com", "netflix"},
        {"no-reply@spotify.com", "spotify"},
        {"no-reply@pass.media", "premier"},
        {"info@more.tv", "more_tv"},
        {"notification@payture.ru", "okko"}
    };
};
