#include <util/string/join.h>
#include <mail/iex/media_wrapper/media_parser/class_parser.h>
#include <mail/so/libs/jniwrapper_base/jniwrapper_base.h> // for ProcessJniWrapperException
#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/json_writer.h>

extern "C"
int MediaParserCreateInstance(
        const char* config Y_DECLARE_UNUSED,
        void** out)
{
    try {
        auto parser = new TParser();
        *out = parser;
        return 0;
    } catch (...) {
        return NJniWrapper::ProcessJniWrapperException((char**) (void*)out);
   }
}

extern "C"
void MediaParserDestroyInstance(void* categorizer) {
    delete static_cast<TParser*>(categorizer);
}

extern "C"
int MediaParserApplier(
    void* instance,
    const char* uri Y_DECLARE_UNUSED,
    const char* metainfo Y_DECLARE_UNUSED,
    void* data,
    size_t size,
    void** out)
{
    try {
        auto categorizer = static_cast<TParser*>(instance);
        TStringBuf requestText(static_cast<const char*>(data), size);
        TString result = categorizer->apply(requestText);
        *out = strdup(result.c_str());
    } catch (...) {
        return NJniWrapper::ProcessJniWrapperException((char**) (void*)out);
    }
    if (*out) {
        return 0;
    } else {
        return -1;
    }
}

extern "C"
void MediaParserStrFree(void *s) {
    free(s);
}
