import json
import os

from requests import get
from requests import patch
from requests import post


def get_all_component_names():
    set_components = set(line.strip() for line in open('antifraud_components.txt'))
    return set_components


class StModuleQueueSettings(object):
    token = os.environ.get('ST_TOKEN')
    queue_name = 'ANTIFRAUD'

    # def __init__(self, name='ANTIFRAUD'):
    def __init__(self, name='CHBKTST'):
        self.queue_name = name

    def get_exists_components(self):
        queue_components_json = get('https://st-api.yandex-team.ru/v2/queues/{}/components'.format(self.queue_name),
                                    headers={'Authorization': 'OAuth {}'.format(self.token)}).json()
        print(json.dumps(queue_components_json))
        exists_components = set()
        for item in queue_components_json:
            exists_components.add(item['name'])
        return exists_components

    def get_non_exists_components_names(self):
        all_components = get_all_component_names()
        exists_components = self.get_exists_components()
        non_exists_component = all_components - exists_components
        return non_exists_component

    def create_new_components(self):
        non_exists_components = self.get_non_exists_components_names()
        for new_component in non_exists_components:
            create_new_component_json = {
                'queue': self.queue_name,
                'name': new_component
            }
            response = post('https://st-api.yandex-team.ru/v2/components',
                            headers={'Authorization': 'OAuth {}'.format(self.token)},
                            json=create_new_component_json)
            new_component_id = str(response.json()['id'])
            print('created new component ' + new_component + ' with id ' + new_component_id)

            update_component_permissions_read_write = {
                'users': 'robot-fraud-fighter',
                'groups': [90720],
                'roles': ['assignee', 'follower', 'author', 'access']
            }

            response = patch(
                'https://st-api.yandex-team.ru/v2/components/{}/permissions/read?version=1'.format(new_component_id),
                headers={'Authorization': 'OAuth {}'.format(self.token)},
                json=update_component_permissions_read_write)
            print('updated readers for ' + new_component + ', returns: ' + str(response.json()))

            response = patch(
                'https://st-api.yandex-team.ru/v2/components/{}/permissions/write?version=2'.format(new_component_id),
                headers={'Authorization': 'OAuth {}'.format(self.token)},
                json=update_component_permissions_read_write)
            print('updated editors for ' + new_component + ', returns: ' + str(response.json()))

            update_component_permissions_create = {
                'users': 'robot-fraud-fighter',
                'groups': [962, 90720],
                'roles': ['assignee', 'follower', 'author', 'access']
            }
            response = patch(
                'https://st-api.yandex-team.ru/v2/components/{}/permissions/create?version=3'.format(new_component_id),
                headers={'Authorization': 'OAuth {}'.format(self.token)},
                json=update_component_permissions_create)
            print('updated creators for ' + new_component + ' returns: ' + str(response.json()))
        return response


if __name__ == "__main__":
    #queue_settings = StModuleQueueSettings(name='ANTIFRAUD')
    queue_settings = StModuleQueueSettings(name='FRAUDINCIDENT')
    print('queue components names = ' + str(queue_settings.get_exists_components()))
    print('all components names = ' + str(get_all_component_names()))
    print('non exists components names = ' + str(queue_settings.get_non_exists_components_names()))

    queue_settings.create_new_components()
