#!/bin/bash
set -exo pipefail

export parallel=0
export configs=logrotate_incremental.d/*.conf
export gzip_opts="-5"
export gzip=./minigzip
export maxsize=$((1024**3 / 2))
export LOCKED=./logrotate_incremental.sh
BEFORE=$(df -h /logs | tail -1 | cut -c29-34,41-44)
nice -n 19 ionice -c3 ./logrotate_incremental_auto_mode.sh /logs/logrotate_incremental_status
AFTER=$(df -h /logs | tail -1 | cut -c29-34,41-44)
date "+Rotation %d %b %R: $BEFORE -> $AFTER"
