package ru.yandex.sobb.front;

import ru.yandex.collection.PatternMap;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.HttpProxyConfigBuilder;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.logger.BackendAccessLoggerConfigDefaults;
import ru.yandex.logger.LoggerConfigBuilder;
import ru.yandex.logger.LoggersConfigBuilder;
import ru.yandex.logger.ProxyAccessLoggerConfigDefaults;
import ru.yandex.logger.SearchProxyAccessLoggerConfigDefaults;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class Config extends ImmutableHttpProxyConfig {
    private final ImmutableHttpHostConfig blackbox;
    private final ImmutableHttpHostConfig msearch;
    private final String secret;
    private final int uuidsPerUser;

    public Config(final IniConfig config) throws ConfigException {
        super(createConfig(config));
        blackbox =
            new HttpHostConfigBuilder(config.section("blackbox")).build();
        msearch =
            new HttpHostConfigBuilder(config.section("msearch")).build();
        secret = config.getString("secret");
        uuidsPerUser = config.getInt("uuids-per-user");
    }

    private static ImmutableHttpProxyConfig createConfig(final IniConfig ini)
        throws ConfigException
    {
        HttpProxyConfigBuilder config = new HttpProxyConfigBuilder(ini);
        config.name("bugbounty-front");
        LoggerConfigBuilder loggerConfig =
            new LoggerConfigBuilder(
                BackendAccessLoggerConfigDefaults.INSTANCE);
        loggerConfig.single().logFormat(
            BackendAccessLoggerConfigDefaults.INSTANCE
                .logFormat()
                + ProxyAccessLoggerConfigDefaults.LOG_FORMAT_SUFFIX
                + " %{"
                + SearchProxyAccessLoggerConfigDefaults.HITS_COUNT
                + '}');

        config.loggers().accessLoggers(
            LoggersConfigBuilder.loadLoggers(
                ini.section(LoggersConfigBuilder.ACCESSLOG),
                new PatternMap<>(loggerConfig)));
        return config.build();
    }

    public ImmutableHttpHostConfig blackbox() {
        return blackbox;
    }

    public String secret() {
        return secret;
    }

    public int uuidsPerUser() {
        return uuidsPerUser;
    }

    public ImmutableHttpHostConfig msearch() {
        return msearch;
    }
}
