package ru.yandex.sobb.front;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;


/**
 * Must agree with
 * mail/iex/iex_proxy/main/java/ru/yandex/iex/proxy/BugBountyHandler.java
 */
public class UuidsProducer {
    private static final byte[] salt = {80, -35, 4, -48};

    private final Key aesKey;
    private final ThreadLocal<Cipher> cipher;
    private final Base64.Encoder encoder =
        Base64.getUrlEncoder().withoutPadding();
    private final int uuidsPerUser;

    public UuidsProducer(String secret, int uuidsPerUser) {
        aesKey = new SecretKeySpec(
            Base64.getUrlDecoder().decode(secret), "AES");
        cipher = ThreadLocal.withInitial(() -> {
            try {
                Cipher cur = Cipher.getInstance("AES/ECB/NoPadding");
                cur.init(Cipher.ENCRYPT_MODE, aesKey);
                return cur;
            } catch (
                NoSuchAlgorithmException
                | NoSuchPaddingException
                | InvalidKeyException e) {
                return null;
            }
        });
        this.uuidsPerUser = uuidsPerUser;
    }

    public List<String> generate(long uid) {
        ByteBuffer bb = ByteBuffer.allocate(16);
        bb.putLong(uid);
        for (int i = 0; i < salt.length; ++i) {
            bb.put(12 + i, salt[i]);
        }

        List<String> res = new ArrayList<>(uuidsPerUser);
        for (int i = 0; i < uuidsPerUser; ++i) {
            bb.putInt(8, i);
            try {
                byte[] bytes = cipher.get().doFinal(bb.array());
                String encoded = encoder.encodeToString(bytes);
                res.add("Q" + encoded);
            } catch (IllegalBlockSizeException | BadPaddingException e) {
                // unreachable cause bb.capacity = 16
            }
        }
        return res;
    }
}
