package client

import (
	"a.yandex-team.ru/mail/iex/taksa/future"
)

func responseToString(response interface{}) (string, error) {
	str, ok := response.(string)
	if ok {
		return str, nil
	}
	return "", future.Error("string expected")
}

func makeResponseGetter(f future.Functor) ResponseGetter {
	return func() (string, error) {
		if response, err := f(); err == nil {
			return responseToString(response)
		} else {
			return "", err
		}
	}
}

func (impl *Impl) GetAsync(params Params) ResponseGetter {
	f := future.Functor(func() (interface{}, error) {
		return impl.get(params)
	}).Async()

	if timeout := params.Timeout; timeout != 0 {
		return makeResponseGetter(func() (interface{}, error) {
			return f.GetTimed(timeout)
		})
	} else {
		return makeResponseGetter(func() (interface{}, error) {
			return f.Get()
		})
	}
}

func (impl *Impl) Get(params Params) (string, error) {
	return impl.GetAsync(params)()
}
