package client

import (
	"a.yandex-team.ru/mail/iex/taksa/tutil"
	"fmt"
	"time"
)

type Config struct {
	Timeout        tutil.Timeout `json:"timeout"`
	ConnectTimeout tutil.Timeout `json:"connect_timeout"`
	MaxTimeout     tutil.Timeout `json:"max_timeout"`
}

func (config Config) String() string {
	return fmt.Sprintf("timeout=%v, connect_timeout=%v, max_timeout=%v",
		time.Duration(config.Timeout), time.Duration(config.ConnectTimeout), time.Duration(config.MaxTimeout))
}

func Default() Config {
	return Config{
		Timeout:        tutil.Timeout(time.Duration(1) * time.Second),
		ConnectTimeout: tutil.Timeout(time.Duration(100) * time.Millisecond),
		MaxTimeout:     tutil.Timeout(time.Duration(10) * time.Second)}
}

func (Config) GetUnfilledMandatoryFields() (fields []string) {
	return
}
