package client

type Mock struct {
	Err  error
	Data string
}

func (mock Mock) Get(params Params) (response string, err error) {
	if mock.Err != nil {
		return "", mock.Err
	}
	return mock.Data, nil
}

func (mock Mock) GetAsync(params Params) ResponseGetter {
	return func() (string, error) { return mock.Get(params) }
}
