package config

import (
	"fmt"
)

func Get(path string) (*Config, *ConfigError) {
	fmt.Printf("[taksa] configuration file path: %v\n", path)

	file, err := openFile(path)
	if err != nil {
		return nil, err
	}

	defer func() { _ = file.Close() }()

	config, err := parse(file)
	if err != nil {
		return nil, err
	}

	if e := config.checkMandatoryFields(); e != nil {
		return nil, &ConfigError{"fill mandatory fields from", e}
	}

	fmt.Printf("[taksa] loaded config: {\n\t%v}\n", config)

	return config, nil
}
