package config

import (
	"fmt"
)

type ConfigError struct {
	Op   string
	Orig error
}

func (e *ConfigError) Error() string {
	return fmt.Sprintf("cannot %v config file [%v]", e.Op, e.Orig)
}

type LackError struct {
	fields []string
}

func (e *LackError) Error() string {
	return fmt.Sprintf("lack of mandatory fields [%v]", e.fields)
}
