package config

import (
	"os"
)

func openFile(path string) (*os.File, *ConfigError) {
	if _, err := os.Stat(path); err != nil {
		return nil, &ConfigError{"stat", err}
	}
	file, err := os.Open(path)
	if err != nil {
		return nil, &ConfigError{"open", err}
	}
	return file, nil
}
