package config

import (
	"encoding/json"
	"os"
)

func parse(file *os.File) (*Config, *ConfigError) {
	decoder := json.NewDecoder(file)
	config := getDefaultConfig()
	if err := decoder.Decode(&config); err != nil {
		return nil, &ConfigError{"parse", err}
	}
	return config, nil
}
