package config

import (
	"a.yandex-team.ru/mail/iex/taksa/client"
	"a.yandex-team.ru/mail/iex/taksa/methods/list"
	"a.yandex-team.ru/mail/iex/taksa/server"
	"a.yandex-team.ru/mail/iex/taksa/widgets"
	"fmt"
)

type Config struct {
	LogFile  string         `json:"log"`
	LogLevel string         `json:"log_level"`
	Server   server.Config  `json:"server"`
	Client   client.Config  `json:"client"`
	List     list.Config    `json:"list"`
	Widgets  widgets.Config `json:"widgets"`
}

func (config Config) String() string {
	return fmt.Sprintf("logfile = %v\n"+
		"\tloglevel = %v\n"+
		"\tserver = [ %v ]\n"+
		"\tclient = [ %v ]\n"+
		"\twidgets = [%v]\n"+
		"\tlist = [%v]\n",
		config.LogFile, config.LogLevel, config.Server, config.Client, config.Widgets, config.List)
}

func getDefaultConfig() *Config {
	config := new(Config)
	config.LogLevel = "debug"
	config.Server = server.Default()
	config.Client = client.Default()
	config.List = list.Default()
	config.Widgets = widgets.Default()
	return config
}

func (config Config) checkMandatoryFields() *LackError {
	var fields []string
	if config.LogFile == "" {
		fields = append(fields, "log")
	}
	fields = append(fields, config.Client.GetUnfilledMandatoryFields()...)
	fields = append(fields, config.List.GetUnfilledMandatoryFields()...)
	fields = append(fields, config.Widgets.GetUnfilledMandatoryFields()...)
	if len(fields) > 0 {
		return &LackError{fields}
	}
	return nil
}
