package currency

import "fmt"

type GeoCurrency struct {
	geoCurrencyMap map[CountryGeoID]string
}

type GeoCurrencyInterface interface {
	GetCurrencyByGeoid(geoid CountryGeoID) (string, error)
}

func GetGeoCurrencyInstance() GeoCurrencyInterface {
	return &geoCurrencyInstance
}

func (impl *GeoCurrency) GetCurrencyByGeoid(geoid CountryGeoID) (string, error) {
	str, ok := impl.geoCurrencyMap[geoid]
	if !ok {
		return "", Error(fmt.Sprintf("currency not found for %v", geoid))
	}
	return str, nil
}

var geoCurrencyInstance = GeoCurrency{
	geoCurrencyMap: map[CountryGeoID]string{
		84:     "USD",
		93:     "ARS",
		94:     "BRL",
		95:     "CAD",
		96:     "EUR",
		102:    "GBP",
		113:    "EUR",
		114:    "EUR",
		115:    "BGN",
		116:    "HUF",
		117:    "LTL",
		118:    "EUR",
		119:    "NOK",
		120:    "PLN",
		121:    "EUR",
		122:    "EUR",
		123:    "EUR",
		124:    "EUR",
		125:    "CZK",
		126:    "CHF",
		127:    "SEK",
		134:    "CNY",
		135:    "KRW",
		137:    "JPY",
		139:    "NZD",
		149:    "BYR",
		159:    "KZT",
		167:    "AZN",
		168:    "AMD",
		169:    "GEL",
		170:    "TMT",
		171:    "UZS",
		179:    "EUR",
		180:    "RSD",
		181:    "ILS",
		187:    "UAH",
		203:    "DKK",
		204:    "EUR",
		205:    "EUR",
		206:    "EUR",
		207:    "KGS",
		208:    "MDL",
		209:    "TJS",
		210:    "AED",
		211:    "AUD",
		225:    "RUB",
		246:    "EUR",
		983:    "TRY",
		994:    "INR",
		995:    "THB",
		1056:   "EGP",
		10013:  "JMD",
		10015:  "BOB",
		10017:  "CUP",
		10020:  "MAD",
		10022:  "SCR",
		10023:  "LYD",
		10024:  "TND",
		10029:  "AUD",
		10030:  "FJD",
		10054:  "ALL",
		10057:  "BAM",
		10063:  "EUR",
		10064:  "ISK",
		10067:  "CHF",
		10068:  "MKD",
		10069:  "EUR",
		10070:  "EUR",
		10074:  "EUR",
		10077:  "RON",
		10083:  "HRK",
		10088:  "EUR",
		10089:  "GIP",
		10090:  "AFN",
		10091:  "BDT",
		10093:  "VND",
		10095:  "IDR",
		10097:  "MYR",
		10098:  "MVR",
		10099:  "MNT",
		10100:  "MMK",
		10101:  "NPR",
		10102:  "PKR",
		10104:  "KPW",
		10105:  "SGD",
		10108:  "PHP",
		10109:  "LKR",
		10532:  "BHD",
		10535:  "JOD",
		10536:  "IRR",
		10537:  "KWD",
		10538:  "LBP",
		10540:  "SAR",
		10542:  "SYP",
		20271:  "MXN",
		20274:  "BND",
		20572:  "IQD",
		20574:  "EUR",
		20733:  "XOF",
		20736:  "XAF",
		20741:  "NGN",
		20746:  "XCD",
		20747:  "USD",
		20754:  "XCD",
		20762:  "CDF",
		20764:  "USD",
		20768:  "ETB",
		20769:  "SVC",
		20785:  "USD",
		20790:  "EUR",
		20802:  "GHS",
		20818:  "GNF",
		20826:  "DZD",
		20854:  "MGA",
		20856:  "XCD",
		20860:  "WST",
		20862:  "CLP",
		20869:  "XOF",
		20915:  "SBD",
		20917:  "DOP",
		20954:  "ZWL",
		20957:  "SDG",
		20968:  "GTQ",
		20972:  "LAK",
		20975:  "KHR",
		20989:  "ERN",
		20992:  "PYG",
		21004:  "XOF",
		21007:  "ZAR",
		21010:  "GMD",
		21019:  "BBD",
		21042:  "XCD",
		21045:  "XAF",
		21131:  "CRC",
		21137:  "XAF",
		21143:  "XOF",
		21151:  "MWK",
		21156:  "PEN",
		21165:  "XOF",
		21171:  "XOF",
		21175:  "HNL",
		21182:  "AOA",
		21184:  "VEF",
		21187:  "TTD",
		21191:  "COP",
		21196:  "ZMW",
		21198:  "XAF",
		21199:  "STD",
		21203:  "EUR",
		21208:  "TZS",
		21214:  "BIF",
		21217:  "NAD",
		21219:  "SLL",
		21223:  "KES",
		21227:  "SOS",
		21230:  "UGX",
		21231:  "NIO",
		21235:  "MZN",
		21239:  "BWP",
		21241:  "MUR",
		21251:  "SZL",
		21261:  "LSL",
		21278:  "LRD",
		21289:  "UYU",
		21297:  "KMF",
		21299:  "PAB",
		21321:  "HTG",
		21326:  "CVE",
		21330:  "XPF",
		21331:  "XAF",
		21339:  "XOF",
		21344:  "SRD",
		21349:  "MRO",
		21359:  "EUR",
		21371:  "RWF",
		21395:  "XCD",
		21426:  "XCD",
		21441:  "XOF",
		21475:  "DJF",
		21477:  "GYD",
		21486:  "QAR",
		21534:  "XCD",
		21536:  "AWG",
		21538:  "ANG",
		21544:  "BZD",
		21546:  "BMD",
		21550:  "BTN",
		21551:  "YER",
		21556:  "VUV",
		21562:  "USD",
		21567:  "DKK",
		21570:  "KYD",
		21572:  "AUD",
		21574:  "NZD",
		21578:  "USD",
		21580:  "USD",
		21582:  "AUD",
		21584:  "XPF",
		21586:  "OMR",
		21589:  "USD",
		21595:  "USD",
		21599:  "TOP",
		21601:  "AUD",
		21610:  "EUR",
		29386:  "RUB",
		29387:  "RUB",
		37176:  "XCD",
		98539:  "AUD",
		98542:  "NZD",
		101519: "FKP",
		101521: "EUR",
		108137: "SSP",
		109724: "ANG",
	},
}
