package currency

import "fmt"

type QuoteIds struct {
	quoteIdsMap map[string]int
}

type QuoteIdsInterface interface {
	GetQuoteID(quote string) (int, error)
}

func GetQuoteIdsInstance() QuoteIdsInterface {
	return &quoteIdsInstance
}

func (impl *QuoteIds) GetQuoteID(quote string) (int, error) {
	id, ok := impl.quoteIdsMap[quote]
	if !ok {
		return 0, Error(fmt.Sprintf("quote id not found for %v", quote))
	}
	return id, nil
}

var quoteIdsInstance = QuoteIds{
	quoteIdsMap: map[string]int{
		"EUR/USD": 6,
		"JPY/EUR": 501,
		"BGN/EUR": 502,
		"CZK/EUR": 503,
		"DKK/EUR": 504,
		"GBP/EUR": 505,
		"HUF/EUR": 506,
		"PLN/EUR": 507,
		"RON/EUR": 508,
		"SEK/EUR": 509,
		"CHF/EUR": 510,
		"NOK/EUR": 511,
		"HRK/EUR": 512,
		"RUB/EUR": 513,
		"TRY/EUR": 514,
		"AUD/EUR": 515,
		"BRL/EUR": 516,
		"CAD/EUR": 517,
		"CNY/EUR": 518,
		"ILS/EUR": 520,
		"INR/EUR": 521,
		"KRW/EUR": 522,
		"MXN/EUR": 523,
		"NZD/EUR": 524,
		"SGD/EUR": 525,
		"THB/EUR": 526,
		"ZAR/EUR": 527,
		"IDR/EUR": 528,
		"MYR/EUR": 529,
		"PHP/EUR": 530,
		"SEK/RUB": 10033,
		"USD/KZT": 5000,
		"EUR/KZT": 5001,
		"RUB/KZT": 5002,
		"CHF/KZT": 5003,
		"GBP/KZT": 5004,
		"JPY/KZT": 5005,
		"UAH/KZT": 5006,
		"BYR/KZT": 5007,
		"TRY/KZT": 5008,
		"KRW/KZT": 5010,
		"IRR/KZT": 5011,
		"BYR/UAH": 3003,
		"KZT/UAH": 3009,
		"TRY/UAH": 3029,
		"USD/TRY": 40052,
		"EUR/TRY": 40053,
		"RUB/TRY": 40054,
		"CHF/TRY": 40055,
		"GBP/TRY": 40056,
		"JPY/TRY": 40057,
		"UAH/TRY": 40061,
		"CAD/TRY": 40062,
		"DKK/TRY": 40063,
		"SEK/TRY": 40064,
		"NOK/TRY": 40065,
		"SAR/TRY": 40066,
		"KWD/TRY": 40067,
		"AUD/TRY": 40068,
		"RON/TRY": 40069,
		"PKR/TRY": 40070,
		"IRR/TRY": 40071,
		"CNY/TRY": 40072,
		"BGN/TRY": 40073,
		"BYR/RUB": 10010,
		"TRY/RUB": 10011,
		"UZS/RUB": 10012,
		"TJS/RUB": 10014,
		"MDL/RUB": 10016,
		"KGS/RUB": 10017,
		"CNY/RUB": 10018,
		"KRW/RUB": 10019,
		"INR/RUB": 10020,
		"AMD/RUB": 10021,
		"AZN/RUB": 10022,
		"BGN/RUB": 10023,
		"BRL/RUB": 10024,
		"CZK/RUB": 10025,
		"DKK/RUB": 10026,
		"HUF/RUB": 10027,
		"NOK/RUB": 10030,
		"PLN/RUB": 10031,
		"RON/RUB": 10032,
		"SGD/RUB": 10034,
		"ZAR/RUB": 10036,
		"TMT/RUB": 10037,
		"THB/USD": 70001,
		"THB/RUB": 70002,
		"ILS/RUB": 70004,
		"IDR/RUB": 70005,
		"HRK/RUB": 70006,
		"MXN/RUB": 70007,
		"MYR/RUB": 70008,
		"NZD/RUB": 70009,
		"PHP/RUB": 70010,
		"USD/GBP": 72001,
		"USD/SAR": 72003,
		"USD/COP": 72006,
		"USD/DZD": 72010,
		"USD/KWD": 72014,
		"EUR/ISK": 73001,
		"USD/UZS": 75000,
		"EUR/UZS": 75001,
		"RUB/UZS": 75002,
		"GBP/UZS": 75003,
		"KZT/UZS": 75004,
		"USD/RUB": 10000,
		"UAH/RUB": 10006,
		"EUR/RUB": 10001,
		"GBP/RUB": 10004,
		"JPY/RUB": 10005,
		"CHF/RUB": 10007,
		"USD/EUR": 500,
		"GBP/UAH": 3001,
		"USD/UAH": 3005,
		"RUB/UAH": 3015,
		"CHF/UAH": 3024,
		"JPY/UAH": 3026,
		"EUR/UAH": 3027,
		"KZT/RUB": 10009,
		"USD/ISK": 73000,
	},
}
