package errs

import (
	"encoding/json"
)

type BadRequest struct {
	Err string `json:"error"`
}

func (req BadRequest) Error() string {
	return marshal(req)
}

type InternalError struct {
	Err string `json:"error"`
}

func (err InternalError) Error() string {
	return marshal(err)
}

func marshal(e error) string {
	out, marshallingError := json.MarshalIndent(e, "", "\t")
	if marshallingError != nil {
		out = []byte("oops, error marshalling error")
	}
	return string(out)
}
