package experiments

import (
	"a.yandex-team.ru/mail/iex/taksa/tutil"
	"strings"
)

type Experiments []string

const (
	Comma     string = ","
	Semicolon string = ";"
)

type BadExperiments string

func (experiments BadExperiments) Error() string {
	return string(experiments)
}

func ParseHeader(s string) (exps Experiments, err error) {
	expBoxes := strings.Split(s, Semicolon)
	for _, expBox := range expBoxes {
		split := strings.Split(strings.TrimSpace(expBox), Comma)
		if len(split) == 0 || len(split) == 1 && split[0] == "" {
			continue
		}
		if len(split) != 3 {
			return Experiments(nil), BadExperiments("malformed triple enabledexpboxes header: " + expBox)
		}
		exps = append(exps, strings.TrimSpace(split[0]))
	}
	return
}

func (experiments Experiments) ContainsOneOf(exps Experiments) bool {
	for _, exp := range exps {
		if tutil.ContainsString(exp, experiments) {
			return true
		}
	}
	return false
}
