package future

type Functor func() (interface{}, error)

func (fn Functor) Async() Future {
	p, f := NewPromiseFuture()
	go func() {
		p.Set(fn())
	}()
	return f
}

type FunctorGroup []Functor

func (group FunctorGroup) Async() (f FutureGroup) {
	for _, fn := range group {
		f = append(f, fn.Async())
	}
	return f
}
