package future

import (
	"time"
)

type PromiseGroup []Promise

type FutureGroup []Future

func consumeTime(from, amount time.Duration) time.Duration {
	if from > 0 && amount < from {
		return from - amount
	}
	return 0
}

func (group *FutureGroup) reset() {
	*group = FutureGroup{}
}

func (group *FutureGroup) Get() (res []interface{}, err []error) {
	defer group.reset()
	for _, f := range *group {
		if c, e := f.Get(); e == nil {
			res = append(res, c)
		} else {
			err = append(err, e)
		}
	}
	return
}

func (group *FutureGroup) getTimed(
	since func(time.Time) time.Duration,
	limit time.Duration) (res []interface{}, err []error) {

	defer group.reset()
	for _, f := range *group {
		t := time.Now()
		if c, e := f.GetTimed(limit); e == nil && c != nil {
			res = append(res, c)
		} else if e != nil {
			err = append(err, e)
		}
		limit = consumeTime(limit, since(t))
	}
	return
}

func (group *FutureGroup) GetTimed(limit time.Duration) (res []interface{}, err []error) {
	return group.getTimed(time.Since, limit)
}
