package iex

import (
	"a.yandex-team.ru/mail/iex/taksa/client"
	"a.yandex-team.ru/mail/iex/taksa/logger"
	"a.yandex-team.ru/mail/iex/taksa/meta"
	"encoding/json"
	"fmt"
	"time"
)

type Fact struct {
	Envelope meta.Envelope
	IEX      []interface{}
}

type Impl struct {
	Host string
	Port int
	Path string
	Log  logger.Interface
	Cli  client.Interface
}

func (impl Impl) Fetch(user User, envelopes []meta.Envelope, headers map[string]string, timeout time.Duration,
	retry *string, sync bool, taksaHost string) (res []Fact, err error) {
	url := "http://" + impl.Host
	if impl.Port != 80 {
		url = url + fmt.Sprintf(":%v", impl.Port)
	}
	url = url + fmt.Sprintf("/%v?uid=%v", impl.Path, user.UID)
	if user.SUID != "" {
		url = url + fmt.Sprintf("&suid=%v", user.SUID)
	}
	if user.MDB != "" {
		url = url + fmt.Sprintf("&mdb=%v", user.MDB)
	}
	for _, envelope := range envelopes {
		url = url + "&mid=" + envelope.Mid
	}
	if taksaHost != "" {
		url = url + "&taksa-host=" + taksaHost
	}
	if retry != nil {
		url = url + "&retry=" + *retry
	}
	// force iex extracting without timeout
	if sync {
		url = url + "&extract=true"
		timeout = 0
	}

	got, err := impl.Cli.Get(client.Params{URL: url, Headers: headers, Timeout: timeout})
	if err != nil {
		return
	}
	var response map[string][]interface{}
	if err = json.Unmarshal([]byte(got), &response); err != nil {
		impl.Log.ErrorExtra("iex", "cannot parse iex json", logger.Extra{"err": err.Error()})
		return
	}
	for _, envelope := range envelopes {
		facts, found := response[envelope.Mid]
		if found {
			res = append(res, Fact{Envelope: envelope, IEX: facts})
		}
	}
	return
}
