package logger

import (
	"os"
)

type Extra map[string]string

type Interface interface {
	Error(module, reason string)
	ErrorExtra(module, reason string, extra Extra)
	Info(module, reason string)
	InfoExtra(module, reason string, extra Extra)
	Debug(module, reason string)
	DebugExtra(module, reason string, extra Extra)
}

func Error(uid, xrid, module, reason string, extra Extra) {
	log(TSKV{UID: uid, XRID: xrid, Module: module, Reason: reason, Extras: extra, LogLevel: ErrorLevel})
}

func Info(uid, xrid, module, reason string, extra Extra) {
	log(TSKV{UID: uid, XRID: xrid, Module: module, Reason: reason, Extras: extra, LogLevel: InfoLevel})
}

func Debug(uid, xrid, module, reason string, extra Extra) {
	log(TSKV{UID: uid, XRID: xrid, Module: module, Reason: reason, Extras: extra, LogLevel: DebugLevel})
}

func Service(module, reason string) {
	log(TSKV{Module: module, Reason: reason, LogLevel: InfoLevel})
}

func StartWriter(fileName string, level string) {
	file, err := os.OpenFile(fileName, os.O_WRONLY|os.O_CREATE|os.O_APPEND, 0644)
	if err != nil {
		file = os.Stdout
	}
	writer = &Writer{file, make(chan TSKV, BufferSize), levelByName(level)}
	go work()
}

func StopWriter() {
	writer.finalize()
	writer.close()
}
