package logger

type Level uint

const (
	DebugLevel Level = 0
	InfoLevel  Level = 1
	ErrorLevel Level = 2
)

func (level Level) String() string {
	switch level {
	case DebugLevel:
		return "debug"
	case InfoLevel:
		return "info"
	case ErrorLevel:
		return "error"
	}
	return "error"
}

func levelByName(level string) Level {
	switch level {
	case "debug":
		return DebugLevel
	case "info":
		return InfoLevel
	case "error":
		return ErrorLevel
	}
	return DebugLevel
}
