package logger

import (
	"fmt"
	"strings"
	"time"
)

type TSKV struct {
	LogLevel Level
	UID      string
	XRID     string
	Module   string
	Reason   string
	Extras   Extra
}

func filter(str string) string {
	return strings.Trim(fmt.Sprintf("%q", str), "\"")
}

func (tskv TSKV) String() string {
	if tskv.Reason == "" {
		return ""
	}
	now := time.Now()
	prefix := fmt.Sprintf("tskv\t"+
		"tskv_format=mail-taksa-log\t"+
		"timestamp=%v\t"+
		"nano=%v\t"+
		"timezone=%v\t"+
		"unixtime=%v\t",
		now.Format("2006-01-02 15:04:05"),
		now.Nanosecond(),
		now.Format("-0700"),
		now.Unix())
	fields := fmt.Sprintf("status=%v\t"+
		"uid=%v\t"+
		"x-request-id=%v\t"+
		"module=%v\t"+
		"reason=[%v]\t",
		tskv.LogLevel.String(),
		tskv.UID,
		tskv.XRID,
		tskv.Module,
		filter(tskv.Reason))
	extra := ""
	for k, v := range tskv.Extras {
		extra += k + "=" + filter(v) + "\t"
	}
	return prefix + fields + extra + "\n"
}
