package logger

import (
	"fmt"
	"os"
	"time"
)

const (
	BufferSize int = 100
)

var writer *Writer = nil

type Writer struct {
	file     *os.File
	channel  chan TSKV
	logLevel Level
}

func (writer *Writer) finalize() {
	if writer.channel != nil {
		for i := 0; i < BufferSize; i++ {
			writer.channel <- TSKV{}
		}
		close(writer.channel)
	}
}

func (writer *Writer) close() {
	if writer.file != nil {
		_ = writer.file.Close()
	}
}

func (writer *Writer) realWrite(event TSKV) {
	n, err := writer.file.WriteString(event.String())
	if err != nil {
		fmt.Printf("[taksa] logger error %v, written %v bytes\n", err, n)
	}
}

func work() {
	for event := range writer.channel {
		writer.realWrite(event)
	}
}

func log(event TSKV) {
	if writer == nil {
		panic(fmt.Sprintln("[taksa] Fatal: log writer not initialized"))
	}
	if event.LogLevel < writer.logLevel {
		return
	}
	select {
	case writer.channel <- event:
	case <-time.After(1 * time.Second):
		fmt.Println("[taksa] logger write: could not send an event to channel within 1 second, discard it")
	}
}
