package main

import (
	"a.yandex-team.ru/mail/iex/taksa/client"
	"a.yandex-team.ru/mail/iex/taksa/config"
	"a.yandex-team.ru/mail/iex/taksa/logger"
	"a.yandex-team.ru/mail/iex/taksa/methods/list"
	"a.yandex-team.ru/mail/iex/taksa/server"
	"flag"
	"fmt"
)

var configPath = flag.String("config", "/etc/taksa/config.json", "path to the config file")

func bindMethods(cfg *config.Config) {
	server.BindMethod("list", list.Method{Cfg: cfg.List, Wcfg: cfg.Widgets})
	server.BindMethod("", server.NotFound{})
}

func main() {
	fmt.Println("[taksa] STARTING TAKSA DAEMON")
	flag.Parse()
	cfg, err := config.Get(*configPath)
	if err != nil {
		panic(fmt.Sprintf("[taksa] Fatal: %v, terminate", err))
	}

	logger.StartWriter(cfg.LogFile, cfg.LogLevel)
	defer logger.StopWriter()

	client.Init(cfg.Client)

	server.Launch(cfg.Server)
	defer server.Shutdown()
	bindMethods(cfg)

	for command := range server.Control {
		switch command {
		case server.STOP:
			logger.Service("main", "STOPPING TAKSA DAEMON")
			return
		case server.RELOAD:
			logger.Service("main", "RELOAD TAKSA DAEMON")
			logger.StopWriter()
			cfg, err = config.Get(*configPath)
			if err != nil {
				logger.Service("main", fmt.Sprintf("reload config failed: [%v]", err))
			} else {
				client.Init(cfg.Client)
				logger.StartWriter(cfg.LogFile, cfg.LogLevel)
				server.Reload(cfg.Server)
				bindMethods(cfg)
			}
		}
		continue
	}
}
