package list

import (
	"a.yandex-team.ru/mail/iex/taksa/tutil"
	"fmt"
	"time"
)

type Config struct {
	IexHost     string        `json:"iex_host"`
	SyncIexHost string        `json:"sync_iex_host"`
	IexPort     int           `json:"iex_port"`
	SyncIexPort int           `json:"sync_iex_port"`
	IexPath     string        `json:"iex_path"`
	IexTimeout  tutil.Timeout `json:"iex_timeout"`
	Timeout     tutil.Timeout `json:"timeout"`
}

func (config Config) String() string {
	return fmt.Sprintf("iex=%v:%v/%v, iex_timeout=%v\n\ttimeout=%v",
		config.IexHost, config.IexPort, config.IexPath,
		time.Duration(config.IexTimeout), time.Duration(config.Timeout))
}

func Default() Config {
	return Config{IexHost: "iex-proxy.search.yandex.net", IexPath: "facts",
		IexTimeout: tutil.Timeout(time.Duration(100) * time.Millisecond),
		Timeout:    tutil.Timeout(time.Duration(5) * time.Second)}
}

func (config Config) GetUnfilledMandatoryFields() (fields []string) {
	if config.IexPort == 0 {
		fields = append(fields, "iex_port")
	}
	return
}
