package request

import (
	"io/ioutil"
	"net/http"
)

type Impl struct {
	orig *http.Request
	body []byte
}

func New(r *http.Request) *Impl {
	buf, err := ioutil.ReadAll(r.Body)
	if err != nil {
		buf = make([]byte, 0)
	}
	return &Impl{orig: r, body: buf}
}

func (impl Impl) GetParam(key string) string {
	return impl.orig.FormValue(key)
}

func (impl Impl) HasParam(key string) bool {
	_ = impl.orig.ParseForm()
	_, has := impl.orig.Form[key]
	return has
}

func (impl Impl) GetList(key string) []string {
	_ = impl.orig.ParseForm()
	return append(impl.orig.Form[key], impl.orig.PostForm[key]...)
}

func (impl Impl) GetHeader(key string) string {
	if len(impl.orig.Header[key]) > 0 {
		return impl.orig.Header[key][0]
	}
	return ""
}

func (impl Impl) GetBody() []byte {
	return impl.body
}

func (impl Impl) GetPath() string {
	return impl.orig.URL.Path
}

func (impl Impl) GetQuery() string {
	return impl.orig.URL.RawQuery
}
