package request

type Mock struct {
	Params  map[string]string
	Body    []byte
	Headers map[string]string
}

func (mock Mock) GetParam(key string) string {
	return mock.Params[key]
}

func (mock Mock) HasParam(key string) bool {
	_, has := mock.Params[key]
	return has
}

func (mock Mock) GetList(key string) []string {
	return []string{mock.Params[key]}
}

func (mock Mock) GetHeader(key string) string {
	return mock.Headers[key]
}

func (mock Mock) GetBody() []byte {
	return mock.Body
}

func (Mock) GetPath() string {
	return "path"
}

func (Mock) GetQuery() string {
	return "query"
}
