package request

type Request interface {
	GetTld() string
	GetMobile() bool
}

type RequestImpl struct {
	Req        Interface
	DefaultTLD string
}

func (impl RequestImpl) GetTld() string {
	tld := impl.Req.GetParam("tld")
	switch tld {
	case "ru", "ua", "com", "by", "kz", "рф", "net", "com.tr", "az", "com.am",
		"com.ge", "co.il", "kg", "lt", "lv", "md", "tj", "tm", "uz", "fr", "ee":
		return tld
	default:
		return impl.DefaultTLD
	}
}

func (impl RequestImpl) GetMobile() bool {
	val := impl.Req.GetParam("mobile")
	return val == "yes" ||
		val == "true" ||
		val == "1" ||
		val == "da"
}

type RequestMock struct {
	Tld    string
	Mobile bool
}

func (mock RequestMock) GetTld() string {
	return mock.Tld
}

func (mock RequestMock) GetMobile() bool {
	return mock.Mobile
}
