package server

import (
	"fmt"
	"net/http"

	"a.yandex-team.ru/mail/iex/taksa/logger"
)

type Ctrl int

const (
	STOP   Ctrl = 0
	RELOAD Ctrl = 1
)

var Control chan Ctrl = make(chan Ctrl)

func stopHandler(w http.ResponseWriter, r *http.Request) {
	logger.Service("server", "ctrl/stop")
	_, _ = fmt.Fprintln(w, "STOPPING TAKSA DAEMON!")
	Control <- STOP
}

func reloadHandler(w http.ResponseWriter, r *http.Request) {
	logger.Service("server", "ctrl/reload")
	_, _ = fmt.Fprintln(w, "RELOAD TAKSA DAEMON!")
	Control <- RELOAD
}

func pingHandler(w http.ResponseWriter, r *http.Request) {
	_, _ = fmt.Fprintln(w, "pong")
}
