package server

import (
	"a.yandex-team.ru/mail/iex/taksa/logger"
	"a.yandex-team.ru/mail/iex/taksa/request"
	"crypto/md5"
	"fmt"
	"time"
)

type APILogger struct {
	session [md5.Size]byte
	uid     string
	xrid    string
}

func newAPILogger(r request.Interface) *APILogger {
	rnd, _ := time.Now().MarshalBinary()
	return &APILogger{
		session: md5.Sum(rnd),
		uid:     r.GetParam("uid"),
		xrid:    r.GetHeader("X-Request-Id"),
	}
}

func (apiLogger *APILogger) accept(r request.Interface) {
	extra := logger.Extra{
		"path":  r.GetPath(),
		"query": fmt.Sprintf("[%v]", r.GetQuery()),
	}
	apiLogger.InfoExtra("server", "accept", extra)
}

func (apiLogger *APILogger) done(code int, taken time.Duration) {
	extra := logger.Extra{
		"code": fmt.Sprintf("%v", code),
		"time": fmt.Sprintf("%.03f", taken.Seconds()),
	}
	apiLogger.InfoExtra("server", "done", extra)
}

func (apiLogger *APILogger) Error(module, reason string) {
	extra := logger.Extra{"session": fmt.Sprintf("%x", apiLogger.session)}
	logger.Error(apiLogger.uid, apiLogger.xrid, module, reason, extra)
}
func (apiLogger *APILogger) ErrorExtra(module, reason string, extra logger.Extra) {
	extra["session"] = fmt.Sprintf("%x", apiLogger.session)
	logger.Error(apiLogger.uid, apiLogger.xrid, module, reason, extra)
}
func (apiLogger *APILogger) Info(module, reason string) {
	extra := logger.Extra{"session": fmt.Sprintf("%x", apiLogger.session)}
	logger.Info(apiLogger.uid, apiLogger.xrid, module, reason, extra)
}
func (apiLogger *APILogger) InfoExtra(module, reason string, extra logger.Extra) {
	extra["session"] = fmt.Sprintf("%x", apiLogger.session)
	logger.Info(apiLogger.uid, apiLogger.xrid, module, reason, extra)
}
func (apiLogger *APILogger) Debug(module, reason string) {
	extra := logger.Extra{"session": fmt.Sprintf("%x", apiLogger.session)}
	logger.Debug(apiLogger.uid, apiLogger.xrid, module, reason, extra)
}
func (apiLogger *APILogger) DebugExtra(module, reason string, extra logger.Extra) {
	extra["session"] = fmt.Sprintf("%x", apiLogger.session)
	logger.Debug(apiLogger.uid, apiLogger.xrid, module, reason, extra)
}
