package server

import (
	"fmt"
	"net"
	"net/http"

	"a.yandex-team.ru/mail/iex/taksa/logger"
)

var listener *net.Listener

var mux *http.ServeMux

var allServed chan struct{}

func bind() {
	mux.HandleFunc("/ping", pingHandler)
	mux.HandleFunc("/ctrl/stop", stopHandler)
	mux.HandleFunc("/ctrl/reload", reloadHandler)
	mux.HandleFunc("/", http.NotFound)
}

func Launch(cfg Config) {
	logger.Service("server", "launch")
	mux = http.NewServeMux()
	bind()
	l, err := net.Listen("tcp", fmt.Sprintf("[::1]:%v", cfg.Port))
	if err != nil {
		logger.Service("server", fmt.Sprintf("launch error: [%v]", err.Error()))
		panic(fmt.Sprintf("[taksa] Fatal: server launch error [%v]", err))
	}
	listener = &l
	allServed = make(chan struct{})
	go func() {
		_ = http.Serve(l, mux)
		close(allServed)
	}()
}

func Shutdown() {
	logger.Service("server", "shutdown")
	if listener != nil {
		_ = (*listener).Close()
		<-allServed
	}
	mux = nil
}

func Reload(cfg Config) {
	logger.Service("server", "reload")
	Shutdown()
	Launch(cfg)

}
