package tanker

import (
	"fmt"
	"time"
)

type impl struct {
	ru map[StringID]string
}

var instance impl = impl{
	ru: map[StringID]string{
		HotelBooking:        "Подобрать гостиницу",
		Print:               "Распечатать",
		WebCheckIn:          "Регистрация на рейс",
		Aeroexpress:         "Билет на аэроэкспресс",
		Taxi:                "Заказать такси",
		FreeCancelDate:      "Бесплатная отмена до",
		FreeCancelDateShort: "отмена до",
		ChangeBooking:       "Изменить бронь",
		CheckWeather:        "Проверить погоду",
		Row:                 "ряд",
		Seat:                "место",
		And:                 "и",
		Delete:              "Удалить",
		Faq:                 "Справка",
		Compose:             "Исправить",
		ConfirmEmail:        "Подтвердить адрес",
		RestorePassword:     "Восстановить пароль",
		Unsubscribe:         "Отписаться",
		YourOrder:           "Ваш заказ",
		GoToOrder:           "Перейти к заказу",
		BoardingPass:        "Посадочный талон",
		WillGo:              "Пойду",
		WillNotGo:           "Не пойду",
		Look:                "Посмотреть",
		Updated:             "Обновлено",
		FreeTime:            "Освободившееся время: ",
		Spam:                "СПАМ: ",
	},
}

type Error string

func (e Error) Error() string {
	return "l10n error: " + string(e)
}

func (impl *impl) GetString(id StringID) (string, error) {
	str, ok := impl.ru[id]
	if !ok {
		return "", Error(fmt.Sprintf("key %v not found for loc %v", id, "ru"))
	}
	return str, nil
}

func (*impl) GetTimeInterval(start, end time.Time) string {
	return fmt.Sprintf("с %v по %v", start.Format("15:04"), end.Format("15:04"))
}

func (*impl) GetDay(t time.Time) (res string, err error) {
	switch t.Format("Mon") {
	case "Mon":
		return "Понедельник", nil
	case "Tue":
		return "Вторник", nil
	case "Wed":
		return "Среда", nil
	case "Thu":
		return "Четверг", nil
	case "Fri":
		return "Пятница", nil
	case "Sat":
		return "Суббота", nil
	case "Sun":
		return "Воскресенье", nil
	default:
		return "", Error(fmt.Sprintf("day %v not found for loc %v", t.Format("Mon"), "ru"))
	}
}

func locMonth(m string) (string, error) {
	switch m {
	case "Jan":
		return "января", nil
	case "Feb":
		return "февраля", nil
	case "Mar":
		return "марта", nil
	case "Apr":
		return "апреля", nil
	case "May":
		return "мая", nil
	case "Jun":
		return "июня", nil
	case "Jul":
		return "июля", nil
	case "Aug":
		return "августа", nil
	case "Sep":
		return "сентября", nil
	case "Oct":
		return "октября", nil
	case "Nov":
		return "ноября", nil
	case "Dec":
		return "декабря", nil
	default:
		return "", Error(fmt.Sprintf("month %v not found for loc %v", m, "ru"))
	}
}

func (*impl) GetDate(t time.Time) (res string, err error) {
	day := t.Format("2")
	month := t.Format("Jan")
	var monthL7d string
	monthL7d, err = locMonth(month)
	res = fmt.Sprintf("%v %v", day, monthL7d)
	return
}

func locMonthShort(m string) (string, error) {
	switch m {
	case "Jan":
		return "янв.", nil
	case "Feb":
		return "фев.", nil
	case "Mar":
		return "мар.", nil
	case "Apr":
		return "апр.", nil
	case "May":
		return "мая", nil
	case "Jun":
		return "июня", nil
	case "Jul":
		return "июля", nil
	case "Aug":
		return "авг.", nil
	case "Sep":
		return "сен.", nil
	case "Oct":
		return "окт.", nil
	case "Nov":
		return "ноя.", nil
	case "Dec":
		return "дек.", nil
	default:
		return "", Error(fmt.Sprintf("month %v not found for loc %v", m, "ru"))
	}
}

func (*impl) GetDateShort(t time.Time) (res string, err error) {
	day := t.Format("2")
	month := t.Format("Jan")
	var monthL7d string
	monthL7d, err = locMonthShort(month)
	res = fmt.Sprintf("%v %v", day, monthL7d)
	return
}

func (*impl) GetTickets(num int) (res string, err error) {
	var str string
	if num/10 == 1 {
		str = "билетов"
	} else {
		switch num % 10 {
		case 1:
			str = "билет"
		case 2, 3, 4:
			str = "билета"
		default:
			str = "билетов"
		}
	}
	res = fmt.Sprintf("%v %v", num, str)
	return
}

func (*impl) GetNights(num int) (res string, err error) {
	var str string
	if num/10 == 1 {
		str = "ночей"
	} else {
		switch num % 10 {
		case 1:
			str = "ночь"
		case 2, 3, 4:
			str = "ночи"
		default:
			str = "ночей"
		}
	}
	res = fmt.Sprintf("%v %v", num, str)
	return
}

func (*impl) GetSuccessBounce(recipients []string) (res string, err error) {
	switch len(recipients) {
	case 1:
		res = fmt.Sprintf("Письмо на адрес %v успешно доставлено", recipients[0])
	default:
		res = "Письмо успешно доставлено"
	}
	return
}

func (*impl) GetIPBlockedBounce(recipients []string) (res string, err error) {
	switch len(recipients) {
	case 1:
		res = fmt.Sprintf("Письмо не доставлено на адрес %v", recipients[0])
	default:
		res = "Письмо не доставлено"
	}
	return
}

func (*impl) GetType1Bounce(recipients []string) (res string, err error) {
	switch len(recipients) {
	case 1:
		res = fmt.Sprintf("Письмо отправлено на несуществующий адрес %v", recipients[0])
	default:
		res = "Письмо отправлено на несуществующий адрес"
	}
	return
}

func (*impl) GetType2Bounce(recipients []string) (res string, err error) {
	switch len(recipients) {
	case 1:
		res = fmt.Sprintf("Письмо, отправленное на %v, похоже на спам", recipients[0])
	default:
		res = "Письмо, отправленное вами, похоже на спам"
	}
	return
}

func (*impl) GetType3Bounce(recipients []string) (res string, err error) {
	switch len(recipients) {
	case 1:
		res = fmt.Sprintf("Ящик %v не смог принять письмо, так как письмо оказалось слишком большим", recipients[0])
	default:
		res = "Ящик получателя не смог принять письмо, так как письмо оказалось слишком большим"
	}
	return
}

func (*impl) GetType4Bounce(recipients []string) (res string, err error) {
	switch len(recipients) {
	case 1:
		res = fmt.Sprintf("Почтовому сервису получателя %v показалось, что в письме найден вирус", recipients[0])
	default:
		res = "Почтовому сервису получателя показалось, что в письме найден вирус"
	}
	return
}

func (*impl) GetType5Bounce(recipients []string) (res string, err error) {
	switch len(recipients) {
	case 1:
		res = fmt.Sprintf("Ящик получателя %v переполнен", recipients[0])
	default:
		res = "Ящик получателя переполнен"
	}
	return
}

func (*impl) GetType6Bounce(recipients []string) (res string, err error) {
	switch len(recipients) {
	case 1:
		res = fmt.Sprintf("Ящик %v не может принимать письма", recipients[0])
	default:
		res = "Ящик получателя не может принимать письма"
	}
	return
}

func (*impl) GetType8Bounce(recipients []string) (res string, err error) {
	switch len(recipients) {
	case 1:
		res = fmt.Sprintf("Письмо не доставлено на адрес %v", recipients[0])
	default:
		res = "Письмо не доставлено"
	}
	return
}

func (*impl) GetDmarcBounce(originalFrom string) (res string, err error) {
	res = fmt.Sprintf("Письмо не может быть отправлено с адреса %v", originalFrom)
	return
}

func (*impl) GetMXS(domain string) (res string, err error) {
	res = fmt.Sprintf("Почтовый сервис %v", domain)
	return
}

func (*impl) GetEshopStatus(status string) (string, error) {
	switch status {
	case "OrderConfirmation":
		return "подтвержден", nil
	case "OrderPaid":
		return "оплачен", nil
	case "OrderProcessing":
		return "в обработке", nil
	case "OrderCancelled":
		return "отменен", nil
	case "OrderDelivered":
		return "доставлен", nil
	case "OrderInTransit":
		return "доставляется", nil
	case "OrderPaymentDue":
		return "ждет оплаты", nil
	case "OrderPickupAvailable":
		return "готов к выдаче", nil
	case "OrderReturned":
		return "возвращен", nil
	default:
		return "", Error("unknown status")
	}
}

func (*impl) GetCancelledEvent(event string) (string, error) {
	return fmt.Sprintf("Встреча \"%v\" отменена", event), nil
}

func GetInstance( /*l*/ Locale) Interface {
	return &instance
}
